import java.io.*;
class Paskyrimas {
	int h1, h2, m1, m2; //h1 - paskyrimo pradios val sk; h2 - pabaigos val sk; m1 - pradzios min sk; m2 - pabaigos min sk.
	Paskyrimas(int g1, int n1, int g2, int n2) //Konstruktorius gaunantis bei grazinantis paskyrimu valandu ir minuciu reiksmes.
	{
		h1 = g1;
		m1 = n1;
		h2 = g2;
		m2 = n2;
	}
	public int kokshp()
	{
		return h1;
	}
	public int koksmp()
	{
		return m1;
	}
	public int koksha()
	{
		return h2;
	}
	public int koksma()
	{
		return m2;
	}
}

class Metodai
{
	public Paskyrimas skaitoIrasaIsFailo(BufferedReader ds) throws IOException //Metodas skirtas dienos paskyrimu nuskaitymui ir irasu isskaidymui.
	{
		String eilute; //Kintamas i kuri bus padedama nuskaityta failo eilute.
		int h1, h2, m1, m2; //h1 - paskyrimo pradios val sk; h2 - pabaigos val sk; m1 - pradzios min sk; m2 - pabaigos min sk.
		try
		{
			eilute = ds.readLine(); //Nuskaitoma eilute is failo.
			h1 = Integer.parseInt(eilute.substring(0, 2).trim()); //Pirmi du simboliai eiluteje reiskia paskyrimo pradzios valandas.
			if (h1 < 10 || h1 > 17) //Paskyrimo pradzios valandos turi buti tarp 10 ir 17, jei si salyga nepatenkinta atspausdinamas pranesimas ir irasas praleidziamas.
			{
			   throw new NumberFormatException();
			}
			m1 = Integer.parseInt(eilute.substring(3, 5).trim()); //3 ir 4 simboliai eiluteje reiskia paskyrimo pradzios minutes.
			if (m1 < 0 || m1 > 60) //Paskyrimo pradzios minutes turi buti tarp 0 ir 60, jei si salyga nepatenkinta atspausdinamas pranesimas ir irasas praleidziamas.
			{
			   throw new NumberFormatException();
			}
			h2 = Integer.parseInt(eilute.substring(6, 8).trim()); //6 ir 7 simboliai eiluteje reiskia paskyrimo pabaigos valandas.
			if (h2 < 10 || h2 > 17) //Paskyrimo pabaigos valandos turi buti tarp 10 ir 17, jei si salyga nepatenkinta atspausdinamas pranesimas ir irasas praleidziamas.
			{
			   throw new NumberFormatException();
			}
			m2 = Integer.parseInt(eilute.substring(9, 11).trim()); //9 ir 10 simboliai eiluteje reiskia paskyrimo pradzios minutes.
			if (m2 < 0 || m2 > 60) //Paskyrimo pabaigos minutes turi buti tarp 0 ir 60, jei si salyga nepatenkinta atspausdinamas pranesimas ir irasas praleidziamas.
			{
			   throw new NumberFormatException();
			}
			return new Paskyrimas(h1, m1, h2, m2); //Jei visos salygos patenkintos grazinama isskaidyta eilute kurios tipas konstruktorius "Paskyrimas".
		}
		catch (NumberFormatException e) //Netinkami skaiciai eiluteje - atspausdinamas pranesimas.
		{
		    System.out.println("Blogi duomenys - irasas praleistas");
		}
		catch (IndexOutOfBoundsException qq) //Duomenys netelpa i masyva - atspausdinamas pranesimas.
		{
	        System.out.println("Per trumpas masyvas. Like irasai ignoruoti.");
		}
		catch (IOException e) //Nenuskaito failo eilutes - atspausdinamas pranesimas.
		{
			System.out.println("Skaitymo klaida");
		}
		return null; //Jei netinkami skaiciai eiluteje, duomenys netelpa i masyva ar nenuskaito failo eilutes - atspausdina atitinkama pranesia ir eilute praleidzia.
	}
	public void isvesti (Paskyrimas mas[], int n, int g) //Procedura skirta suskaiciuoti dienos ilgiausia poguli is isvesti informacija i ekrana.
	{
		int i = 0, j = 600, k, u; //i - skaitliukas; j - paskyrimo pabaigos laikas minutemis (pirma reiksme 10val); k - paskyrimo pradzios laikas minutemis; u - laiko tarpas tarp paskyrimu minutemis.
		int masy[] = new int[250]; //Apibreziamas masyvas laiko tarpams tarp paskyrimu fiksuoti.
		while(i<=n) //Ciklas sudedantis visu laiko tarpus tarp paskyrimu i masyva, atliekamas tiek kartu kiek toje dienoje yra paskyrimu.
		{
			if (i != n) //Salyga jei ne paskutinis dienos paskyrimas.
			{
				k = mas[i].kokshp()*60+mas[i].koksmp(); //Suskaiciuojamas paskyrimo pradzios laikas minutemis.
				u = k-j; //Surandamas laiko tarpas tarp paskyrimu.
				j = mas[i].koksha()*60+mas[i].koksma(); //Suskaiciuojamas paskyrimo pabaigos laikas minutemis.
				masy[i] = u; //Rastas laiko tarpas idedamas i masyva.
				i++; //Skaitliukas padidinamas vinetu.
			}
			else //Salyga jei paskutinis dienos paskyrimas.
			{
				u = 1080-j; //Randamas laiko tarpas, pabaiga 18val - paskutinios paskyrimo pabaigos laikas.
				masy[i] = u; //Rastas laiko tarpas idedamas i masyva.
				i++; //Skaitliukas padidinamas vinetu.
			}
		}
		i = 0; //Skaitliukas grazinamas i 0.
		int q = 0; //Kintamas skirtas pazymeti dizdiausiai masyvo reiksmei (pradzioj 0).
		int w = 0; //Kintamas skirtas pazymeti kelinta masyvo reiksme buvo didziausia.
		while (i<=n) //Ciklas skirtas rasti didziausiai masyvo reiksmei, atliekamas tiek kartu kiek toje dienoje yra paskyrimu.
		{
			if (q<masy[i]) //Iki siol didzausia reiksme lyginama su einamaja, jei ji didesne pakeiciama kintamojo q reiksme.
			{
				q = masy[i];
				w = i; //Pazimima kelintas masyvo elementas didziausias.
			}
			i++; //kaitliukas padidinamas vinetu.
		}
		int val, min; //Kintamieji laiko tarpa tarp paskyrimu isskaidantys i valandas ir minutes.
		val = q/60; //Suskaiciuojama kiek ilgiausiame laisvame laiko tarpe yra valandu.
		min = q-val*60; //Suskaiciuojama kiek lieka minuciu.
		if (w == 0) //Salyga jei ilgiausias laiko tarpas yra pries pirma paskyrima.
		{
			if (val == 0) //Salyga jei valandu kiekis - 0.
			{
				System.out.println("Diena " + g + ". Ilgiausias pogulis prasideda 10:00 ir tesis " + min + " min.");
			}
			else //Salyga jei valandu kiekis >0.
			{
				System.out.println("Diena " + g + ". Ilgiausias pogulis prasideda 10:00 ir tesis " + val + " val. " + min + " min.");
			}
		}
		else //Salyga jei ilgiausias laiko tarpas ne pries pirma paskyrima.
		{
			if (val == 0) //Salyga jei valandu kiekis - 0.
			{
				System.out.println("Diena " + g + ". Ilgiausias pogulis prasideda " + mas[w-1].koksha() + ":" + mas[w-1].koksma() + " ir tesis " + min + " min.");
			}
			else //Salyga jei valandu kiekis >0.
			{
				System.out.println("Diena " + g + ". Ilgiausias pogulis prasideda " + mas[w-1].koksha() + ":" + mas[w-1].koksma() + " ir tesis " + val + " val. " + min + " min.");
			}
		}
	}
}

class Pogulis
{
    public static void main(String[] args) throws IOException
    {
		BufferedReader ds = null;
		try
		{
			File f1 = new File("duom.txt"); //Atidaromas duomenu failas duom.txt.
			ds = new BufferedReader(new FileReader(f1));
		}
		catch (FileNotFoundException e) //Jei failas nerastas atpausdinamas pranesimas ir programa baigia darba.
		{
			System.out.println("Duomenu failas <duom.txt> nerastas.");
			System.exit(0);
		}
		catch (IOException e) //Jei failo negalima atidaryti atpausdinamas pranesimas ir programa baigia darba.
		{
			System.out.println("Klaida atidarant <duom.txt> faila.");
			System.exit(0);
		}
		Metodai met = new Metodai(); //Sukuriamas naujas objektas klase Metodai.
		Paskyrimas sarasas[] = new Paskyrimas[250]; //Apibreziamas masyvas skirtas talpinti dienospaskyrimu laikams.
		String x = ds.readLine(); //Nuskaitoma pirma failo eilute kurioje - skaicius reiskiantis dienos paskyrimu skaiciu.
		int t, g = 0; //t- dienos paskyrimu skaicius; g - dienu skaicius.
		while (x != null) //Ciklas kol nesibaigia failas (kol nenuskaito tuscios eilutes).
		{
			t = Integer.parseInt(x); //Dienos paskyrimu skaicius is String tipo paverciamas i int tipa.
			for (int i = 0; i < t; i++) //Ciklas atliekamas tiek kartu kiek yra dienoje paskyrimu.
			{
		    		Paskyrimas q = met.skaitoIrasaIsFailo(ds); //Kreipiasi i metoda "skaitoIrasaIsFailo".
		    		sarasas[i] = q; //Metodui atlikus darba gauta reiksme iraso i masyva.
			}
			met.isvesti(sarasas, t - 1, g + 1); //Kreipiasi i metoda "isvesti".
			x = ds.readLine(); //Nuskaito failo eilute kurioje - skaicius reiskiantis dienos paskyrimu skaiciu, arba ji tuscia.
			g++; //Dienu skaitliukas.
		}
		try //Uzdaromas duomenu failas, jei nepavyksta uzdaryti atspausdinamas pranesimas.
		{
		ds.close();
		}
		catch (IOException e)
		{
			System.out.println("Klaida uzdarant duomenu faila");
		}
    }
}